/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;

class FileNames {
    private static final String TEMP_DIR_KEY = "uitmp";
    private static final String OBJECTS_FILE_NAME = "objects";
    private static final String GROUP_FILE_NAME_PREFIX = "group.";
    private static final String TASK_GROUP_FILE_NAME_PREFIX = "task.";
    private static final String MO_GROUP_FILE_NAME_PREFIX = "mo.";
    private static final String ALLOWED_TASKS_FILE_NAME_PREFIX = "allowedtasks.";
    private static final String UNACCEPTABLE_FILE_NAME = "unacceptablemanagedobjects";
    private static final String ROOT_MANAGED_OBJECTS_FILE_NAME = "rootmanagedobjects";
    private String tempPathName;
    private String groupFilePrefix;
    private String taskGroupFilePrefix;
    private String moGroupFilePrefix;
    private String allowedTasksFilePrefix;
    private static FileNames instance;
    private static final String TRACE_MASKT = "HUIFILNT";
    private static final String TRACE_MASKF = "HUIFILNF";
    private static final String TRACE_MASKD = "HUIFILND";

    private FileNames() throws HException {
        Trace.trace(TRACE_MASKF, "-> FileNames.FileNames()");
        try {
            this.tempPathName = BaseFileControl.getFilePath(TEMP_DIR_KEY);
            this.groupFilePrefix = this.tempPathName + GROUP_FILE_NAME_PREFIX;
            this.taskGroupFilePrefix = this.groupFilePrefix + TASK_GROUP_FILE_NAME_PREFIX;
            this.moGroupFilePrefix = this.groupFilePrefix + MO_GROUP_FILE_NAME_PREFIX;
            this.allowedTasksFilePrefix = this.tempPathName + ALLOWED_TASKS_FILE_NAME_PREFIX;
        }
        catch (HException hException) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKF, "<- FileNames.FileNames()");
    }

    static synchronized FileNames getFileNames() throws HException {
        if (instance == null) {
            instance = new FileNames();
        }
        return instance;
    }

    String getTaskGroupFileName(String s) {
        return this.taskGroupFilePrefix + s;
    }

    String getManagedObjectGroupFileName(String s) {
        return this.moGroupFilePrefix + s;
    }

    String getAllowedTasksFilePrefix() {
        return this.allowedTasksFilePrefix;
    }

    String getAllowedTasksFileName(String s) {
        return this.allowedTasksFilePrefix + s;
    }

    String getUnacceptableFileName() {
        return this.tempPathName + UNACCEPTABLE_FILE_NAME;
    }

    String getRootFileName() {
        return this.tempPathName + ROOT_MANAGED_OBJECTS_FILE_NAME;
    }

    String getObjectsFileName() {
        return this.tempPathName + OBJECTS_FILE_NAME;
    }

    String getTempPathName() {
        return this.tempPathName;
    }
}

